﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/Clean.master" CodeBehind="GanttSubActivities.aspx.cs" Inherits="GUI.Pages.GanttSubActivities" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CleanContentPlaceHolder" runat="server" >
<div class="page-full-main-content">
     <div class="row">
        <div class="col-md-12 col-sm-12">
        <div class="portlet light bordered light-blue kendo-form">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject bold font-dark uppercase"> <asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Subactivities %>" /> </span>
                        <span class="caption-helper">* <asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, Activities_DragActivitiesToReorder %>" /></span>
                    </div>
                </div>
                <div class="portlet-body form">
                    <div class="form-body">
                        <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true" LoadingPanelID="RadAjaxLoadingPanel1">
                        <div class="row">
                            <div class="col-md-12">
                                <telerik:RadTreeView Skin="Bootstrap" ID="treeView" runat="server" EnableDragAndDrop="true"
                                OnClientNodeDropping="onNodeDropping" ClientIDMode="Static" OnClientNodeDragging="onNodeDragging" MultipleSelect="false"
                                EnableDragAndDropBetweenNodes="true">
					            <NodeTemplate>
						            <%# Eval("OrdinalNumber") %> - <%# Eval("Name") %>
					            </NodeTemplate>
					            <ClientNodeTemplate>
						            #= OrdinalNumber # - #= Name #
					            </ClientNodeTemplate>
                            </telerik:RadTreeView>
                            </div>
                        </div> 
                       </telerik:RadAjaxPanel>
                    </div>
                    <br />
                    <div class="form-actions right">
                            <asp:Button ID="btnSave" CssClass="btn red" OnClick="BtnSaveClick" Text="<%$ Resources:ProjectManagementUI, Common_Save %>"
                            runat="server" />
                        </div>
                </div>
            </div>
        </div>
    </div>
 </div>       
	<telerik:RadAjaxLoadingPanel runat="server" ID="RadAjaxLoadingPanel1"  >
        <div class="updatePanelProgress"><asp:Literal ID="ltrPLeaseWait" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_PleaseWait %>" />...</div>
    </telerik:RadAjaxLoadingPanel>
     <script type="text/javascript">
        //<![CDATA[
        function pageLoad() {
            //get a reference to the needed controls - 
            var spliter = document.getElementById('pnlSplitter');
            spliter.style.height = '0';
            var kontejner = document.getElementsByClassName('container');
            for (i = 0; i < kontejner.length; i++) {
                kontejner[i].style="margin:0 0 0 0;";
            }
        }
        //]]>            
        </script>
    
	<script type="text/javascript">
	    function onNodeDropping(sender, args) {
	        var dest = args.get_destNode();
	        if (dest) {
	            if (dest._textElement.parentNode.className.indexOf("rtHover") != -1) {
	                return;
	            }
	            clientSideEdit(sender, args);
	            args.set_cancel(true);
	            //dropOnTree(args);
	        }
	        else {
	            return;
	        }

	    }

	    function clientSideEdit(sender, args) {
	        var destinationNode = args.get_destNode();

	        if (destinationNode) {
	            var firstTreeView = $find('treeView');


	            firstTreeView.trackChanges();
	            //secondTreeView.trackChanges();
	            var sourceNodes = args.get_sourceNodes();
	            var dropPosition = args.get_dropPosition();

	            //Needed to preserve the order of the dragged items
	            if (dropPosition == "below") {
	                for (var i = sourceNodes.length - 1; i >= 0; i--) {
	                    var sourceNode = sourceNodes[i];
	                    sourceNode.get_parent().get_nodes().remove(sourceNode);

	                    insertAfter(destinationNode, sourceNode);
	                }
	            }
	            else {
	                for (var i = 0; i < sourceNodes.length; i++) {
	                    var sourceNode = sourceNodes[i];
	                    sourceNode.get_parent().get_nodes().remove(sourceNode);

	                    if (dropPosition == "over")
	                        destinationNode.get_nodes().add(sourceNode);
	                    if (dropPosition == "above")
	                        insertBefore(destinationNode, sourceNode);
	                }
	            }
	            destinationNode.set_expanded(true);
	            firstTreeView.commitChanges();
	            //secondTreeView.commitChanges();
	        }
	    }

	    function insertBefore(destinationNode, sourceNode) {
	        var destinationParent = destinationNode.get_parent();
	        var index = destinationParent.get_nodes().indexOf(destinationNode);
	        destinationParent.get_nodes().insert(index, sourceNode);
	    }

	    function insertAfter(destinationNode, sourceNode) {
	        var destinationParent = destinationNode.get_parent();
	        var index = destinationParent.get_nodes().indexOf(destinationNode);
	        destinationParent.get_nodes().insert(index + 1, sourceNode);
	    }

	    function dropOnTree(args) {
	        var text = "";

	        if (args.get_sourceNodes().length) {
	            var i;
	            for (i = 0; i < args.get_sourceNodes().length; i++) {
	                var node = args.get_sourceNodes()[i];
	                text = text + ', ' + node.get_text();
	            }
	        }
	    }

	    function onNodeDragging(sender, args) {
	        //alert(sender);
	    }
	    function closeWin() {
	        //GetRadWindow().BrowserWindow.location.href = 'Default2.aspx';
	        //GetRadWindow().close();
	        GetRadWindow().BrowserWindow.closeWin();
	    }
	    function GetRadWindow() {
	        var oWindow = null; if (window.radWindow)
	            oWindow = window.radWindow;
	        else if (window.frameElement.radWindow)
	            oWindow = window.frameElement.radWindow;
	        return oWindow;
	    }
	</script>
</asp:Content>

